"""ShackleAI Loaner Agent — Uninstaller"""

import os
import shutil
import subprocess
import sys
import tkinter as tk
from tkinter import messagebox
from pathlib import Path

INSTALL_DIR = Path.home() / "ShackleAgent"

BG = "#0a0a0f"
BG3 = "#1f2937"
RED = "#ef4444"
RED_DIM = "#7f1d1d"
WHITE = "#ffffff"
GRAY = "#9ca3af"
GRAY_DIM = "#6b7280"
GREEN = "#10b981"


class UninstallerApp:
    def __init__(self):
        self.root = tk.Tk()
        self.root.title("ShackleAI — Uninstall")
        self.root.geometry("400x320")
        self.root.resizable(False, False)
        self.root.configure(bg=BG)

        self.root.update_idletasks()
        x = (self.root.winfo_screenwidth() - 400) // 2
        y = (self.root.winfo_screenheight() - 320) // 2
        self.root.geometry(f"400x320+{x}+{y}")

        self.build_ui()

    def build_ui(self):
        tk.Label(self.root, text="ShackleAI", font=("Segoe UI", 18, "bold"),
                 fg=WHITE, bg=BG).pack(pady=(25, 0))
        tk.Label(self.root, text="Uninstall Loaner Agent",
                 font=("Segoe UI", 10), fg=GRAY_DIM, bg=BG).pack(pady=(2, 20))

        tk.Label(self.root, text="This will remove:", font=("Segoe UI", 10),
                 fg=GRAY, bg=BG, anchor="w").pack(fill="x", padx=40)

        items_frame = tk.Frame(self.root, bg=BG, padx=50)
        items_frame.pack(fill="x", pady=(5, 0))
        for item in [
            f"Agent files in {INSTALL_DIR}",
            "Stored chunks (encrypted data)",
            "Configuration and login tokens",
            "Desktop shortcut",
        ]:
            tk.Label(items_frame, text=f"  -  {item}", font=("Segoe UI", 9),
                     fg=GRAY, bg=BG, anchor="w").pack(fill="x", pady=1)

        tk.Label(self.root, text="Your ShackleAI account will NOT be deleted.",
                 font=("Segoe UI", 8), fg=GRAY_DIM, bg=BG).pack(pady=(15, 0))

        btn_frame = tk.Frame(self.root, bg=BG, pady=15, padx=40)
        btn_frame.pack(fill="x")

        uninstall_btn = tk.Button(btn_frame, text="Uninstall",
                                   font=("Segoe UI", 11, "bold"),
                                   bg=RED_DIM, fg=WHITE, relief="flat",
                                   activebackground=RED, activeforeground=WHITE,
                                   padx=25, pady=8, cursor="hand2",
                                   command=self.do_uninstall)
        uninstall_btn.pack(side="left")

        cancel_btn = tk.Button(btn_frame, text="Cancel",
                                font=("Segoe UI", 11),
                                bg=BG3, fg=GRAY, relief="flat",
                                activebackground="#374151", activeforeground=WHITE,
                                padx=25, pady=8, cursor="hand2",
                                command=self.root.destroy)
        cancel_btn.pack(side="right")

    def do_uninstall(self):
        # Kill running agent
        try:
            if sys.platform == "win32":
                subprocess.run(["taskkill", "/F", "/IM", "pythonw.exe"],
                               capture_output=True, timeout=5)
        except Exception:
            pass

        errors = []

        # Remove desktop shortcut
        try:
            shortcut = Path.home() / "Desktop" / "ShackleAI Agent.bat"
            if shortcut.exists():
                shortcut.unlink()
        except Exception as e:
            errors.append(f"Desktop shortcut: {e}")

        # Remove install directory
        try:
            if INSTALL_DIR.exists():
                shutil.rmtree(INSTALL_DIR)
        except Exception as e:
            errors.append(f"Install directory: {e}")

        # Show result
        for w in self.root.winfo_children():
            w.destroy()

        if errors:
            tk.Label(self.root, text="!", font=("Segoe UI", 48),
                     fg=RED, bg=BG).pack(pady=(30, 5))
            tk.Label(self.root, text="Partially Removed",
                     font=("Segoe UI", 14, "bold"), fg=WHITE, bg=BG).pack()
            tk.Label(self.root, text="\n".join(errors),
                     font=("Segoe UI", 9), fg=GRAY, bg=BG, wraplength=350).pack(pady=10)
        else:
            tk.Label(self.root, text="✓", font=("Segoe UI", 48),
                     fg=GREEN, bg=BG).pack(pady=(30, 5))
            tk.Label(self.root, text="Uninstalled",
                     font=("Segoe UI", 14, "bold"), fg=WHITE, bg=BG).pack()
            tk.Label(self.root, text="ShackleAI Agent has been completely removed.",
                     font=("Segoe UI", 10), fg=GRAY, bg=BG).pack(pady=10)

        tk.Button(self.root, text="Close", font=("Segoe UI", 10),
                  bg=BG3, fg=GRAY, relief="flat", padx=25, pady=6,
                  cursor="hand2", command=self.root.destroy).pack(pady=10)

    def run(self):
        self.root.mainloop()


if __name__ == "__main__":
    UninstallerApp().run()
